# This script is intended to query the status of a service given a fragment or
# complete name
#
# This script expects that you are passing in 2 parameters
#
# 1. The host name of the Introscope EP Agent that we will send metrics too.
# 2. The port number of the Introscope EP Agent that we will send metrics too.
#
# Example: Assumes that you are running from the location that the files are
# located.
#
#   powershell.exe -File ".\PowerShellServiceStatusQuery.ps1" vaaacnms20.aac.xx.ext 9093
#
# Obtain arguments passed in
# Host: vaaacnms20.aac.xx.ext
# Port: 9093 for preprod, 9090 for prod
param($reportingHost, $reportingPort)

# AITC project acronym
$project = "SQW"

# This script outputs a single number, which is the total number of queued
# messages on all channels in the SIG.
#
# From SIG version: unknown

# Fail fast on any errors
$ErrorActionPreference = "Stop"

# Dump stats to a file using mccommand and read into a variable
# Remove the output file if it exists to make sure we're using fresh stats even
# if mccommand fails.
if (Test-Path stats.csv)
{
   rm stats.csv
}
echo "dump stats tools/stats.csv" | ..\mccommand.exe >$null
$csvData = Get-Content .\stats.csv

# Sum all the "queued" column cells
$totalQ = 0
$snip = $csvData[2..($csvData.length-1)]
$snip | foreach { $q = [int]$_.split(",")[3].trim(); $totalQ += $q }

# Print the total
$totalQ
$metricURL = ("http://" + $reportingHost + ":" + $reportingPort +
"/?metricType=IntCounter&metricName=" + $project + "%7C" + "SIG" + "%7c" +
$env:COMPUTERNAME + "%7c" + "Queue" + "%3a" + "Depth&metricValue=" +
$totalQ)
    
Write-Verbose $metricURL -Verbose
[net.WebClient] $wc = new-object net.WebClient
$probe = $wc.downloadData($metricURL)

